# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 7
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR7_strategy.txt
# LLM Suggested Fallback: C

def harmonious_illusionist(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    total_rounds = 10
    
    # Initial Phase: Cooperate unconditionally
    if current_round <= 3:
        return "C"
    
    # Mid-Game: Test opponent's response
    if current_round <= 7:
        if all(move == "C" for move in opp_history[:3]):
            if current_round == 4:
                return "D"
            if current_round == 5 and opp_history[3] == "D":
                return "C"
            if current_round == 6 and opp_history[4] == "C":
                return "C"
            if current_round == 7 and opp_history[5] == "D":
                return "D"
        else:
            if opp_history[-1] == "D":
                return "D"
            return "C"
    
    # End-Game: Maximize payoff based on history
    if current_round >= 8:
        if sum(1 for move in opp_history if move == "D") > 2:
            return "D"
        if "retaliate" in opponent_program_code.lower() or "defect" in opponent_program_code.lower():
            if current_round >= 9:
                return "D"
        return "C"
    
    # Fallback to Tit-for-Tat if unexpected behavior
    if opp_history:
        return opp_history[-1]
    return "C"